IF EXISTS (
		SELECT *
		FROM SYS.INDEXES
		WHERE NAME = 'IX_PG_CRED_AGRUPAMENTO_NFE'
		)
BEGIN
	DROP INDEX [IX_PG_CRED_AGRUPAMENTO_NFE] ON [dbo].[PG_CRED]
END
GO

IF NOT EXISTS (
		SELECT *
		FROM SYS.INDEXES
		WHERE NAME = 'IX_PG_CRED_AGRUPAMENTO_NFE'
		)
BEGIN
	CREATE NONCLUSTERED INDEX [IX_PG_CRED_AGRUPAMENTO_NFE] ON [dbo].[PG_CRED] (
		[CD_EMP] ASC
		,[CD_FILIAL] ASC
		,[NR_DP] ASC
		,[ANO] ASC
		,[PARC] ASC
		,[STS_DP] ASC
		)
		WITH (
				PAD_INDEX = OFF
				,STATISTICS_NORECOMPUTE = ON
				,SORT_IN_TEMPDB = OFF
				,IGNORE_DUP_KEY = OFF
				,DROP_EXISTING = OFF
				,ONLINE = OFF
				,ALLOW_ROW_LOCKS = ON
				,ALLOW_PAGE_LOCKS = ON
				,FILLFACTOR = 97
				) ON [PRIMARY]
END
GO


